import './style.css';

// Initializing the map

const neshanMap = new ol.Map({
	target: 'map',
	key: import.meta.env.VITE_NESHAN_MAP_API_KEY,
	maptype: 'neshan',
	poi: false,
	traffic: false,
	view: new ol.View({
		center: ol.proj.fromLonLat([51.338076, 35.699756]),
		zoom: 14,
	}),
});

// Define custom styles for markers

const stroke = new ol.style.Stroke({ color: 'red', width: 2 });
const fill = new ol.style.Fill({ color: 'black' });

// Add custom marker 1

const marker1 = new ol.Feature({
	geometry: new ol.geom.Point(ol.proj.fromLonLat([51.336247, 35.712362])),
});

marker1.setStyle(
	new ol.style.Style({
		image: new ol.style.Circle({
			fill: new ol.style.Fill({
				color: '#0077FF',
			}),
			stroke: new ol.style.Stroke({
				color: '#FF0000',
				width: 2,
			}),
			radius: 12,
		}),
	})
);

// Add custom marker 2

const marker2 = new ol.Feature({
	geometry: new ol.geom.Point(ol.proj.fromLonLat([51.352533, 35.714383])),
});

marker2.setStyle(
	new ol.style.Style({
		image: new ol.style.RegularShape({
			fill: fill,
			stroke: stroke,
			points: 4,
			radius: 10,
			angle: Math.PI / 4,
		}),
	})
);

// Add custom marker 3

const marker3 = new ol.Feature({
	geometry: new ol.geom.Point(ol.proj.fromLonLat([51.35985, 35.700305])),
});

marker3.setStyle(
	new ol.style.Style({
		image: new ol.style.RegularShape({
			fill: fill,
			stroke: stroke,
			points: 4,
			radius: 10,
			radius2: 0,
			angle: Math.PI / 4,
		}),
	})
);

// Add custom marker 4

const marker4 = new ol.Feature({
	geometry: new ol.geom.Point(ol.proj.fromLonLat([51.347812, 35.706752])),
});

marker4.setStyle(
	new ol.style.Style({
		image: new ol.style.RegularShape({
			fill: fill,
			stroke: stroke,
			points: 5,
			radius: 10,
			radius2: 4,
			angle: 0,
		}),
	})
);

// Add custom marker 5

const marker5 = new ol.Feature({
	geometry: new ol.geom.Point(ol.proj.fromLonLat([51.347812, 35.709952])),
});

marker5.setStyle(
	new ol.style.Style({
		image: new ol.style.Icon({
			anchor: [0.5, 1],
			scale: 0.05,
			src: '/marker.svg',
		}),
	})
);

// Add source

const vectorSource = new ol.source.Vector({
	features: [marker1, marker2, marker3, marker4, marker5],
});

// Add layer

const vectorLayer = new ol.layer.Vector({
	source: vectorSource,
});

neshanMap.addLayer(vectorLayer);

// Add route

const exampleResponse = {
	routes: [
		{
			overview_polyline: {
				points: 'cy{xEa{sxHCyEr@}FIi@MWi@Um@L[l@A^{Jr@',
			},
			legs: [
				{
					summary: 'میدان انقلاب اسلامی - کارگر شمالی',
					distance: {
						value: 555.0,
						text: '۵۷۵ متر',
					},
					duration: {
						value: 99.0,
						text: '۲ دقیقه',
					},
					steps: [
						{
							name: 'آزادی',
							instruction: 'در جهت شرق در آزادی قرار بگیرید',
							bearing_after: 88,
							type: 'depart',
							distance: {
								value: 197.0,
								text: '۲۰۰ متر',
							},
							duration: {
								value: 35.0,
								text: '۱ دقیقه',
							},
							polyline: 'cy{xEa{sxHAkBAmBDa@BKHs@BWD]J{@',
							start_location: [51.388811, 35.70082],
						},
						{
							name: 'کارگر شمالی',
							instruction:
								'در میدان انقلاب اسلامی، از خروجی سوم، خارج شوید',
							rotaryName: 'میدان انقلاب اسلامی',
							bearing_after: 111,
							type: 'rotary',
							modifier: 'straight',
							exit: 3,
							distance: {
								value: 146.0,
								text: '۱۵۰ متر',
							},
							duration: {
								value: 38.0,
								text: '۱ دقیقه',
							},
							polyline: '}w{xEohtxHDSBUCUESEKGKSOUEW@UJORKXAN?N',
							start_location: [51.390956, 35.700632],
						},
						{
							name: '',
							instruction: 'به مسیر خود ادامه دهید',
							bearing_after: 354,
							type: 'exit rotary',
							modifier: 'right',
							exit: 3,
							distance: {
								value: 212.0,
								text: '۲۲۵ متر',
							},
							duration: {
								value: 39.0,
								text: '۱ دقیقه',
							},
							polyline: 'a|{xEuitxH_ADaBLO@{BRmAH',
							start_location: [51.391154, 35.701293],
						},
						{
							name: 'کارگر شمالی',
							instruction: 'در مقصد قرار دارید',
							bearing_after: 0,
							type: 'arrive',
							distance: {
								value: 0.0,
								text: '',
							},
							duration: {
								value: 0.0,
								text: '',
							},
							polyline: '}g|xEahtxH',
							start_location: [51.390885, 35.703188],
						},
					],
				},
			],
		},
	],
};

// Line's style

const trackStyle = new ol.style.Style({
	stroke: new ol.style.Stroke({
		width: 12,
		color: '#250ECDCC',
	}),
});

// Points style

const pointStyle = new ol.style.Style({
	image: new ol.style.Circle({
		fill: new ol.style.Fill({
			color: '#0077FF',
		}),
		stroke: new ol.style.Stroke({
			color: '#FFFFFF',
			width: 2,
		}),
		radius: 5,
	}),
});

// Decoding the routes

for (let k = 0; k < exampleResponse.routes.length; k++) {
	for (let j = 0; j < exampleResponse.routes[k].legs.length; j++) {
		for (let i = 0; i < exampleResponse.routes[k].legs[j].steps.length; i++) {
			const step = exampleResponse.routes[k].legs[j].steps[i];

			const route = new ol.format.Polyline().readGeometry(step['polyline'], {
				dataProjection: 'EPSG:4326',
				featureProjection: 'EPSG:3857',
			});

			const point = new ol.Feature({
				geometry: new ol.geom.Point(
					ol.proj.fromLonLat(step['start_location'])
				),
			});

			point.setStyle(pointStyle);

			const feature = new ol.Feature({
				type: 'route',
				geometry: route,
			});

			feature.setStyle(trackStyle);

			const vectorSource = new ol.source.Vector({
				features: [feature, point],
			});

			const vectorLayer = new ol.layer.Vector({
				source: vectorSource,
			});

			neshanMap.addLayer(vectorLayer);
		}
	}
}
